// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : text.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////



#include "text.h"
#include "log.h"

#include <stdarg.h>



std::vector<Text*> Text::allText;
LPDIRECT3DDEVICE9   Text::pD3DDevice = NULL;
char                Text::fontName[30];




Text::Text( int xVal, int yVal, int wVal, int hVal, const char* str, int size, int weight, bool italics, int alignVal, int colorVal ) 
{

  // Add instance to the static allText member
  allText.push_back( this );

  // Copy parameter values into private members
  x         = xVal;
  y         = yVal;
  w         = wVal;
  h         = hVal;
  alignment = alignVal;
  m_Color   = colorVal;

  // Unhide text by default
  isHidden  = false;

  // Copy initial string into text
  // NOTE:  For more complex string assignments (ie. variable arguments),
  //        use SetText()
  m_Text = str;

  // Create font using provided parameters
  D3DXCreateFontA( pD3DDevice, size, 0, weight, 0, italics, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY,
                   DEFAULT_PITCH | FF_DONTCARE, fontName, &pFont );

}



Text::~Text() 
{

  pFont->Release();

  std::vector<Text*>::iterator t;
  for ( t = allText.begin(); t != allText.end(); t++ ) 
  {
    if ( (*t) == this ) 
    {
      allText.erase( t );
      break;
    }
  }
}



void Text::render() 
{

  RECT rct;
  rct.left    = x;
  rct.top     = y;
  rct.right   = x + w;
  rct.bottom  = y + h;

  pFont->DrawTextA( NULL, m_Text.c_str(), -1, &rct, alignment, m_Color );

}



void Text::SetPosition( int xVal, int yVal ) 
{

  x = xVal;
  y = yVal;

}



void Text::Move( int xVal, int yVal ) 
{

  x += xVal;
  y += yVal;

}



void Text::SetText( const char* str, ... ) 
{

  // Copy string with optional arguments into 'text' member
  char    Text[500];

  va_list argp;
  va_start( argp, str );
  vsprintf_s( Text, 500, str, argp );
  va_end( argp );

  m_Text = Text;

}



void Text::Hide() 
{ 
  isHidden = true; 
}



void Text::Unhide() 
{ 
  isHidden = false; 
}



void Text::Init( LPDIRECT3DDEVICE9 d3ddev, char* font ) 
{

  Log( "Initializing Text...\n" );

  // Reference device pointer
  pD3DDevice = d3ddev;

  // Copy specified font name
  strcpy_s( fontName, 30, font );

}



void Text::RenderAll() 
{

  std::vector<Text*>::iterator t;
  for ( t = allText.begin(); t != allText.end(); t++ ) 
  {
    if ( !(*t)->isHidden )
    {
      (*t)->render();
    }
  }
}



void Text::ReacquireDevice() 
{

  Log( "Text()  Lost D3DXFONT device.  Reacquiring...\n" );

  std::vector<Text*>::iterator t;
  for ( t = allText.begin(); t != allText.end(); t++ ) 
  {
    (*t)->pFont->OnLostDevice();
  }

}



void Text::ResetDevice() 
{
  Log( "Text()  Lost D3DXFONT device.  Reseting...\n" );

  std::vector<Text*>::iterator t;
  for ( t = allText.begin(); t != allText.end(); t++ ) 
  {
    (*t)->pFont->OnResetDevice();
  }
}



void Text::SetColor( const DWORD Color )
{

  m_Color = Color;

}